/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.v1_8_R3;

import com.andavin.reflect.Reflection;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityItemFrame;
import net.minecraft.server.v1_8_R3.Item;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.Items;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R3.PacketPlayOutMap;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_8_R3.PlayerConnection;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

class MapHelper
extends com.andavin.images.MapHelper {
    static final int DEFAULT_STARTING_ID = 8000;
    private static final Field ENTITY_ID = Reflection.findField(Entity.class, "id");
    private static final Map<UUID, AtomicInteger> MAP_IDS = new HashMap<UUID, AtomicInteger>(4);

    MapHelper() {
    }

    @Override
    protected MapView getWorldMap(int id) {
        return Bukkit.getMap((short)((short)id));
    }

    @Override
    protected int nextMapId(org.bukkit.World world) {
        return MAP_IDS.computeIfAbsent(world.getUID(), __ -> new AtomicInteger(8000)).getAndIncrement();
    }

    @Override
    protected void createMap(int frameId, int mapId, Player player, Location location, BlockFace direction, int rotation, byte[] pixels) {
        ItemStack item = new ItemStack((Item)Items.FILLED_MAP);
        item.setData(mapId);
        EntityItemFrame frame = new EntityItemFrame((World)((CraftWorld)player.getWorld()).getHandle());
        frame.setItem(item);
        frame.setLocation(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        frame.setDirection(CraftBlock.blockFaceToNotch((BlockFace)direction));
        Reflection.setFieldValue(ENTITY_ID, frame, frameId);
        PacketPlayOutSpawnEntity spawnPacket = new PacketPlayOutSpawnEntity((Entity)frame, 71, frame.direction.b());
        BlockPosition position = frame.getBlockPosition();
        spawnPacket.a(MathHelper.d((float)(position.getX() * 32)));
        spawnPacket.b(MathHelper.d((float)(position.getY() * 32)));
        spawnPacket.c(MathHelper.d((float)(position.getZ() * 32)));
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.sendPacket((Packet)spawnPacket);
        connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(frame.getId(), frame.getDataWatcher(), true));
        connection.sendPacket((Packet)new PacketPlayOutMap(mapId, 3, Collections.emptyList(), pixels, 0, 0, 128, 128));
    }

    @Override
    protected void destroyMap(Player player, int[] frameIds) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(frameIds));
    }

    @Override
    protected byte[] createPixels(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        int[] pixels = new int[pixelCount];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        byte[] colors = new byte[pixelCount];
        for (int i = 0; i < pixelCount; ++i) {
            colors[i] = MapPalette.matchColor((Color)new Color(pixels[i], true));
        }
        return colors;
    }
}

